/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.items;

import com.yollo.dmlreforged.DeepMobLearning;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.core.GlitchArmorMaterial;
import com.yollo.dmlreforged.core.configs.BalanceConfigs;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemGlitchArmor
extends ArmorItem {
    private static final int PRISTINE_SET_CHANCE = 16;
    private static final int FRAGMENT_SET_CHANCE = 6;
    private static final int HEART_SET_CHANCE = 1;
    private static final int PRISTINE_SET_NUMBER_OF_DROPS = 2;

    public ItemGlitchArmor(EquipmentSlot slot) {
        super((ArmorMaterial)new GlitchArmorMaterial(), slot, new Item.Properties().m_41491_(DeepMobLearning.Deep_Mob_Learning_TAB));
    }

    public static boolean isSetEquippedByPlayer(ServerPlayer player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemGlitchArmor && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemGlitchArmor && player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemGlitchArmor && player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemGlitchArmor;
    }

    public static boolean isFlyEnabledAndFullSet(ServerPlayer player) {
        return ItemGlitchArmor.isSetEquippedByPlayer(player) && (Boolean)BalanceConfigs.isGlitchArmorCreativeFlightEnabled.get() != false;
    }

    public static void dropPristineMatter(Level level, BlockPos blockPos, ItemStack stack) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 16) {
            MobMetaData meta = DataModelHelper.getMobMetaData(stack);
            ItemEntity drop = new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), meta.getPristineMatterStack(2));
            drop.m_32060_();
            level.m_7967_((Entity)drop);
        }
    }

    public static void dropGlitchFragment(Level level, BlockPos blockPos) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 6) {
            ItemEntity drop = new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)ItemInit.GLITCH_FRAGMENT.get(), 1));
            drop.m_32060_();
            level.m_7967_((Entity)drop);
        }
    }

    public static void dropGlitchHeart(Level level, BlockPos blockPos) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 1) {
            ItemEntity drop = new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)ItemInit.GLITCH_HEART.get(), 1));
            drop.m_32060_();
            level.m_7967_((Entity)drop);
        }
    }

    public Component m_7626_(ItemStack p_41458_) {
        return new TranslatableComponent(super.m_7626_(p_41458_).getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA));
    }

    public void m_7373_(ItemStack p_41421_, Level p_41422_, List<Component> list, TooltipFlag p_41424_) {
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_armor_1"));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_armor_3", new Object[]{new TextComponent(Integer.toString(16)), new TextComponent(Integer.toString(2))}).m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_armor_4").m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_armor_5").m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
    }

    public static class ItemGlitchBoots
    extends ItemGlitchArmor {
        public ItemGlitchBoots() {
            super(EquipmentSlot.FEET);
        }
    }

    public static class ItemGlitchLeggings
    extends ItemGlitchArmor {
        public ItemGlitchLeggings() {
            super(EquipmentSlot.LEGS);
        }
    }

    public static class ItemGlitchChestplate
    extends ItemGlitchArmor {
        public ItemGlitchChestplate() {
            super(EquipmentSlot.CHEST);
        }
    }

    public static class ItemGlitchHelmet
    extends ItemGlitchArmor {
        public ItemGlitchHelmet() {
            super(EquipmentSlot.HEAD);
        }
    }
}

